/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyRunnable;
import org.python.core.imp;
import org.python.objectweb.asm.ClassReader;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BytecodeLoader {
    public static Class<?> makeClass(String string, byte[] byArray, Class<?> ... classArray) {
        Loader loader = new Loader();
        for (Class<?> clazz : classArray) {
            try {
                ClassLoader classLoader = clazz.getClassLoader();
                if (classLoader == null) continue;
                loader.addParent(classLoader);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return loader.loadClassFromBytes(string, byArray);
    }

    public static Class<?> makeClass(String string, List<Class<?>> list, byte[] byArray) {
        if (list != null) {
            return BytecodeLoader.makeClass(string, byArray, list.toArray(new Class[list.size()]));
        }
        return BytecodeLoader.makeClass(string, byArray, new Class[0]);
    }

    public static PyCode makeCode(String string, byte[] byArray, String string2) {
        try {
            Class<?> clazz = BytecodeLoader.makeClass(string, byArray, new Class[0]);
            Object obj = clazz.getConstructor(String.class).newInstance(string2);
            return ((PyRunnable)obj).getMain();
        }
        catch (Exception exception) {
            throw Py.JavaError(exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Loader
    extends URLClassLoader {
        private List<ClassLoader> parents = Generic.list();

        public Loader() {
            super(new URL[0]);
            this.parents.add(imp.getSyspathJavaLoader());
        }

        public void addParent(ClassLoader classLoader) {
            if (!this.parents.contains(classLoader)) {
                this.parents.add(0, classLoader);
            }
        }

        @Override
        protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
            Class<?> clazz = this.findLoadedClass(string);
            if (clazz != null) {
                return clazz;
            }
            for (ClassLoader classLoader : this.parents) {
                try {
                    return classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw new ClassNotFoundException(string);
        }

        public Class<?> loadClassFromBytes(String string, byte[] byArray) {
            Object object;
            if (string.endsWith("$py")) {
                try {
                    object = new ClassReader(byArray);
                    string = ((ClassReader)object).getClassName().replace('/', '.');
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            object = this.defineClass(string, byArray, 0, byArray.length, this.getClass().getProtectionDomain());
            this.resolveClass((Class<?>)object);
            return object;
        }
    }
}

